// 2003/03/18 TrackerConfig.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


using System;
using System.Collections;

namespace NTF.HXD.DOC
{
	/// <summary>
	/// trackerJeS̐ݒB
	/// </summary>
	public class TrackerConfig : IConfig
	{
		
		string name = "name";
		[ValueType("Quote")]
		public string Name
		{
			get{return name;}
			set
			{
				name = Support.ProcessQuote( value );
			}
		}

		string description = "description";
		[ValueType("Quote")]
		public string Description
		{
			get{return description;}
			set
			{
				description = Support.ProcessQuote( value );
			}
		}

		string interval = "240";
		[ValueType("UInt")]
		public string Interval
		{
			get{return interval;}
			set
			{
				try
				{
					uint.Parse( value );
				}
				catch
				{
					return;
				}
				interval = value;
			}
		}

		string nusers = "-1";
		[ValueType("Int")]
		public string Nusers
		{
			get{return nusers;}
			set
			{
				try
				{
					int.Parse( value );
				}
				catch
				{
					return;
				}
				nusers = value;
			}
		}

		string password = "";
		[ValueType("Quote")]
		public string Password
		{
			get{return password;}
			set
			{
				password = Support.ProcessQuote( value );
			}
		}

		ArrayList trackers = new ArrayList();
		[ValueType("Tracker")]
		public ArrayList Trackers
		{
			get{return trackers;}
			set
			{
				if( value != null )
				{
					trackers = value;
				}
			}
		}

		
		public TrackerConfig()
		{
		}

		public void Parse(Context context)
		{
			while(true)
			{
				string token = context.NextToken();
				if( token == null || token.Equals("}") )
				{
					break;
				}
				
				switch(token)
				{
					case"name":
						this.Name = context.NextToken();
						break;

					case"description":
						this.Description = context.NextToken();
						break;

					case"interval":
						this.Interval = context.NextToken();
						break;

					case"nusers":
						this.Nusers = context.NextToken();
						break;

					case"password":
						this.Password = context.NextToken();
						break;

						//ǂݎ̂ĂB
						//gbJ[̐ݒ̓AvP[VݒňB
					case"trackers":
						context.NextToken();
						break;

					default:
						context.NextToken();
//						string[] trakerServers = Support.ProcessQuoteArray(context.CurrentToken());
//						if( trackerServers == null )
//						{
//							break;
//						}
//						for(int i = 0 ; i < trakerServers.Length ; i++ )
//						{
//							this.Trackers.Add( trakerServers[i] );
//						}
						break;
				}
			}
		}

		public System.Text.StringBuilder Save(System.Text.StringBuilder b)
		{

			string trackerValue = string.Empty;
			string[] tracker = Support.ListToStrings( this.Trackers );
			if( tracker != null )
			{
				for(int i = 0 ; i < tracker.Length  ; i++ )
				{
					trackerValue += tracker[i] + ",";
				}
				trackerValue = trackerValue.Remove( trackerValue.Length - 1 , 1 );
			}

			ConfigWriter writer = new ConfigWriter(b);

			writer.StartCategory("tracker");
			writer.WriteComment("name of server");
			writer.WriteQuoteProperty("name" , this.Name);
			writer.WriteLine();
			writer.WriteComment("escription of server");
			writer.WriteQuoteProperty("description" , this.Description );
			writer.WriteLine();

			if( trackerValue != string.Empty )
			{
				writer.WriteComment("trackers to send info to, format is: id:password@tracker1, id:password@tracker2, ...");
				writer.WriteProperty("trackers" , trackerValue);
				writer.WriteLine();
			}
				
			writer.WriteComment("send server info to tracker every <interval> seconds");
			writer.WriteProperty("interval" , this.Interval );
			writer.WriteLine();
			writer.WriteComment("number of users to send to tracker, -1 is real number of users");
			writer.WriteProperty("nusers" , this.Nusers );
			writer.WriteLine();
			writer.WriteComment("password for tracker server");
			writer.WriteQuoteProperty("password" , this.Password );
			writer.EndCategory();

			return b;
		}

	}
}
